function pp=pred(x,y,z,x0,y0,z0,t,p,val)
allowedval=[2,3,5,6,9,10,11,14];
if ~(val==allowedval)
    disp('Please select the number of parameters more carefully')
    stop
end
ae=6378.1e03;
r=sqrt(x.^2+y.^2+z.^2);
num=length(z);
zz=z0*ones(size(z));
xx=x0*ones(size(x));
yy=y0*ones(size(y));
thetae=t+atan((r.*cos(t))./(ae+r.*sin(t)));

iproj=cos(thetae).*sin(p);
jproj=cos(thetae).*cos(p);
kproj=sin(thetae);
xe=r.*iproj;
ye=r.*jproj;
ze=r.*kproj-((r.*cos(thetae)).^2./(2*ae));
switch val
    case {2}
        pp(:,1)=iproj;
        pp(:,2)=jproj;
    case {3}
        pp(:,1)=iproj;
        pp(:,2)=jproj;
        pp(:,3)=kproj;
    case {5}
        pp(:,1)=iproj;
        pp(:,2)=jproj;
        pp(:,3)=iproj.*(xe-xx);
        pp(:,4)=jproj.*(ye-yy);
        pp(:,5)=(iproj.*(ye-yy))+(jproj.*(xe-xx));
    case {6}
        pp(:,1)=iproj;
        pp(:,2)=jproj;
        pp(:,3)=iproj.*(xe-xx);
        pp(:,4)=jproj.*(ye-yy);
        pp(:,5)=(iproj.*(ye-yy))+(jproj.*(xe-xx));
        pp(:,6)=kproj;
    case {7}
        pp(:,1)=iproj;
        pp(:,2)=jproj;
        pp(:,3)=iproj.*(xe-xx);
        pp(:,4)=jproj.*(ye-yy);
        pp(:,5)=(iproj.*(ye-yy))+(jproj.*(xe-xx));
        pp(:,6)=kproj;
        pp(:,7)=iproj.*(ze-zz);
    case {9}
        pp(:,1)=iproj;
        pp(:,2)=jproj;
        pp(:,3)=iproj.*(xe-xx);
        pp(:,4)=jproj.*(ye-yy);
        pp(:,5)=(iproj.*(ye-yy))+(jproj.*(xe-xx));
        pp(:,6)=kproj;
        pp(:,7)=iproj.*(ze-zz);
        pp(:,8)=jproj.*(ze-zz);
        pp(:,9)=kproj.*(ze-zz);
    case {10}
        pp(:,1)=kproj;
        pp(:,2)=iproj.*(ze-zz);
        pp(:,3)=jproj.*(ze-zz);
        pp(:,4)=kproj.*(ze-zz);
    case {11}
        pp(:,1)=iproj;
        pp(:,2)=jproj;
        pp(:,3)=iproj.*(xe-xx);
        pp(:,4)=jproj.*(ye-yy);
        pp(:,5)=(iproj.*(ye-yy))+(jproj.*(xe-xx));
        pp(:,6)=kproj;
        pp(:,7)=iproj.*(ze-zz);
        pp(:,8)=jproj.*(ze-zz);
        pp(:,9)=kproj.*(ze-zz);
        pp(:,10)=kproj.*(xe-xx);
        pp(:,11)=kproj.*(ye-yy);
    case {14}
        pp(:,1)=iproj;
        pp(:,2)=jproj;
        pp(:,3)=iproj.*(xe-xx);
        pp(:,4)=jproj.*(ye-yy);
        pp(:,5)=(iproj.*(ye-yy))+(jproj.*(xe-xx));
        pp(:,6)=kproj;
        pp(:,7)=iproj.*(ze-zz);
        pp(:,8)=jproj.*(ze-zz);
        pp(:,9)=kproj.*(ze-zz);
        pp(:,10)=kproj.*(xe-xx);
        pp(:,11)=kproj.*(ye-yy);
        pp(:,12)=iproj.*(xe-xx).*(xe-xx)/2;
        pp(:,13)=iproj.*(ze-zz).*(xe-xx);
        pp(:,14)=iproj.*(ze-zz).*(ze-zz)/2;
end

return
end